//
//  InsuredMemberSelectViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/8/3.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "InsuredMemberSelectViewController.h"
#import "UIColor+Hex.h"
#import "Constants.h"

#import "InsuredMemberTableViewCell.h"

@interface InsuredMemberSelectViewController ()<UITableViewDelegate,UITableViewDataSource>
{
    BOOL edit;
}

@property (nonatomic, strong)UITableView *tableView;

@property (nonatomic, strong)UIView *footerView;

@property (nonatomic, strong)UIView *backgroundView;

@property (nonatomic, strong)UIButton *btn_add;

@property (nonatomic, strong)NSMutableArray *dataArray;

@end

@implementation InsuredMemberSelectViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
    
    [self.view addSubview:self.tableView];
    
    //起点发生变化
    self.edgesForExtendedLayout=UIRectEdgeBottom;
    
    [self configNavBar];
}

- (void)configNavBar
{
   UIButton *rightButton = [[UIButton alloc] initWithFrame:CGRectMake(SCREEN_WIDTH - 70,100, 50, 50)];
   [rightButton setTitle:@"编辑" forState:UIControlStateNormal];
    [rightButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    rightButton.titleLabel.font = [UIFont systemFontOfSize:15*WIDTHRADIU];
    [rightButton addTarget:self action:@selector(btnEditClick:) forControlEvents:UIControlEventTouchUpInside];
    
    
    
    UIBarButtonItem* rightItem = [[UIBarButtonItem alloc]initWithCustomView:rightButton];
    self.navigationItem.rightBarButtonItem = rightItem;
    
  
}

#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;
{
    return self.dataArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    InsuredMemberTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    
    cell.hidden = !edit;
    
    cell.selectionStyle =  UITableViewCellSelectionStyleNone;
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 98 * WIDTHRADIU;
}

#pragma mark - event resposne
- (void)btnClick:(UIButton *)sender
{
    if (sender == self.btn_add) {
        
    }
}

- (void)btnEditClick:(UIButton *)sender
{
    sender.selected = !sender.selected;
    edit = sender.selected;
    if (sender.selected) {
        [sender setTitle:@"完成" forState:UIControlStateNormal];
    }else{
        [sender setTitle:@"编辑" forState:UIControlStateNormal];
    }
    [self.tableView reloadData];
}


#pragma mark - getters and setters
- (NSMutableArray *)dataArray
{
    if (!_dataArray) {
        _dataArray = [[NSMutableArray alloc]initWithObjects:@"1", nil];
    }
    return _dataArray;
}
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, ScreenHeight - cl_kNavigationBarHeight) style:UITableViewStylePlain];
        _tableView.backgroundColor = [UIColor colorWithHex:0xf7f7f7];
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.separatorStyle =  UITableViewCellSeparatorStyleNone;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        [_tableView registerClass:[InsuredMemberTableViewCell class] forCellReuseIdentifier:@"cell"];
        _tableView.tableFooterView = self.footerView;

        _tableView.backgroundView = self.backgroundView;
    }
    return _tableView;
}

- (UIView *)footerView
{
    if (!_footerView) {
        _footerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 93 * WIDTHRADIU)];
        _footerView.backgroundColor = [UIColor clearColor];
        
        [_footerView addSubview:self.btn_add];
        
    }
    return _footerView;
}

- (UIView *)backgroundView
{
    if (!_backgroundView) {
        _backgroundView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, ScreenHeight)];
        _backgroundView.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
        UIView *view = [[UIView alloc]initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, 60 * WIDTHRADIU)];
        view.backgroundColor = [UIColor colorWithHex:0x1886d3];
        [_backgroundView addSubview:view];
    }
    return _backgroundView;
}

- (UIButton *)btn_add
{
    if (!_btn_add) {
        _btn_add = [UIButton buttonWithType:UIButtonTypeCustom];
        _btn_add.frame = CGRectMake(10 * WIDTHRADIU, 15 * WIDTHRADIU, ScreenWidth - 20 * WIDTHRADIU, 78 * WIDTHRADIU);
        [_btn_add setTitle:@"+ 新增人员" forState:UIControlStateNormal];
        [_btn_add setTitleColor:[UIColor colorWithHex:0x1886d3] forState:UIControlStateNormal];
        _btn_add.backgroundColor = [UIColor whiteColor];
        _btn_add.titleLabel.font = [UIFont systemFontOfSize:14 * WIDTHRADIU];
        
         _btn_add.layer.cornerRadius = 10 * WIDTHRADIU;
        _btn_add.layer.shadowColor = [UIColor colorWithHex:0x1886d3].CGColor;
        _btn_add.layer.shadowOffset = CGSizeMake(0, 0);
        _btn_add.layer.shadowOpacity = 0.2;
        _btn_add.layer.shadowRadius = 2 * WIDTHRADIU;
        
        [_btn_add addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_add;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
